/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <regex.h>

#include "udm_config.h"
#include "udm_common.h"
#include "udm_utils.h"
#include "udm_env.h"
#include "udm_parser.h"
#include "udm_robots.h"
#include "udm_host.h"
#include "udm_hrefs.h"
#include "udm_server.h"
#include "udm_filter.h"
#include "udm_url.h"
#include "udm_proto.h"
#include "udm_alias.h"
#include "udm_log.h"
#include "udm_mimetype.h"
#include "udm_stopwords.h"
#include "udm_guesser.h"
#include "udm_vars.h"
#include "udm_synonym.h"
#include "udm_doc.h"
#include "udm_result.h"
#include "udm_spell.h"
#include "udm_db.h"

/**************************** DBAddr ***********************************/

__INDLIB__ UDM_ENV * UdmEnvInit(UDM_ENV *Conf){

	if(!Conf){
		Conf=(UDM_ENV *)malloc(sizeof(UDM_ENV));
		bzero(Conf,sizeof(*Conf));
		Conf->freeme=1;
	}else{
		bzero(Conf,sizeof(*Conf));
	}
	
	Conf->db=UdmDBInit(NULL);
	snprintf(Conf->vardir,sizeof(Conf->vardir),"%s%s",UDM_VAR_DIR,UDMSLASHSTR);
	Conf->logLevel=UDM_LOG_INFO;
	Conf->WordParam.min_word_len=1;
	Conf->WordParam.max_word_len=32;
	Conf->WordParam.correct_factor=1;
	Conf->WordParam.incorrect_factor=1;
	Conf->WordParam.number_factor=1;
	Conf->WordParam.alnum_factor=1;
	Conf->url_number=0x7FFFFFFF;
	
	return(Conf);
}
__INDLIB__ void UdmEnvFree(UDM_ENV * Env){
		
	if(Env->csrv)UdmServerFree(Env->csrv);
	
	UdmDBFree(Env->db);
	UdmDBListFree(&Env->sdcl);
	UdmRobotListFree(&Env->Robots);
	UdmResultFree(&Env->Targets);
	UdmResultFree(&Env->Indexed);
	UdmParserListFree(&Env->Parsers);
	UdmStopListFree(&Env->StopWords);
	UdmHostListFree(&Env->Hosts);
	UdmMimeTypeListFree(&Env->MimeTypes);
	UdmHrefListFree(&Env->Hrefs);
	UdmAliasListFree(&Env->Aliases);
	UdmAliasListFree(&Env->ReverseAliases);
	UdmSynonymListFree(&Env->Synonyms);
	UdmVarListFree(&Env->Sections);
	UdmFilterListFree(&Env->Filters);
	UdmLangMapListFree(&Env->LangMaps);
	UdmServerListFree(&Env->Servers);
	UdmSpellListFree(&Env->Spells);
	UdmAffixListFree(&Env->Affixes);
	UdmVarListFree(&Env->Vars);
	UdmVarListFree(&Env->ExtraHeaders);
	if(Env->freeme)UDM_FREE(Env);
}

__INDLIB__ int UdmEnvErrCode(UDM_ENV * Conf){
	return(Conf->errcode);
}
__INDLIB__ char * UdmEnvErrMsg(UDM_ENV * Conf){
	return(Conf->errstr);
}
